/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import filenet.pe.peorb.FileNet_PERPC.PECallStats;
import filenet.pe.peorb.FileNet_PERPC.PERPCHelper;
import filenet.pe.peorb.client.IPERPC;
import filenet.pe.peorb.client.PERPCProxy;
import filenet.pe.peorb.client.SyncVersion;
import filenet.pe.peorb.registry.ORBRouterInfo;
import filenet.vw.api.VWException;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.RetryManager;
import filenet.vw.base.TTLObject;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.ConfigUtils;
import filenet.vw.server.VWCORBANameURL;
import filenet.vw.server.VWRMIRouterURL;
import filenet.vw.sysutils.VWRegistryTool;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class ORBServiceHelper {
    private static boolean tracedProps = false;
    private static boolean IsIBMORB;
    private static boolean IsWebLogicORB;
    private static boolean IsWAS6;
    private static boolean IsWAS6_Init;
    private static java.lang.Object syncObj;
    private static java.lang.Object syncORBObj;
    private static ORBPOOL G_ORBPOOL;
    protected static boolean GUARD_SHARED_ORB;
    protected static boolean STANDALONE;
    public static long LOCAL_TIMEOUT;
    static final String m_className = "ORBServiceHelper";
    protected static Logger logger;
    protected static Logger propLogger;
    private static final long serialVersionUID = 464L;
    public ORBRouterInfo m_orbRouterInfo;
    private ORB m_orb;
    public NamingContext m_orbNC;
    private String m_host;
    private String m_instanceName;
    private int m_port = 32780;
    private boolean m_useNameService;
    private static final String WAS6_ENABLED_PROPNAME = "filenet.pe.peorb.WAS6";
    private static String WAS6FILE_NAME;
    private static final VWString FAILED_TO_GETVWBROKER_IOR;
    private static final VWString FAILED_TO_CONNECT_TO_VWIOR;
    private static final VWString FAILED_TO_CONNECT_TO_NS;
    private static final long RPC_TIMEOUT_DEFAULT = 180000L;
    private static WeakHashMap<String, TTLObject> IORCache;
    private static Properties ORBPROPS;
    private static boolean calledsetUtf8CodeSet;
    private Vector<java.lang.Object> m_BoundObjects = new Vector(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        java.lang.Object object = syncORBObj;
        synchronized (object) {
            if (G_ORBPOOL != null) {
                G_ORBPOOL.cleanup();
            }
        }
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private static final void setPrivilegedSystemProperty(String propName, String value) {
        final String fpropName = propName;
        final String fValue = value;
        AccessController.doPrivileged(new PrivilegedAction<java.lang.Object>(){

            @Override
            public java.lang.Object run() {
                if (fValue != null) {
                    System.setProperty(fpropName, fValue);
                } else {
                    System.getProperties().remove(fpropName);
                }
                return null;
            }
        });
    }

    public static String _get_FILE_DATE() {
        return "03/08/2012";
    }

    public static String _get_FILE_AUTHOR() {
        return "qdang";
    }

    public static String _get_FILE_REVISION() {
        return "dts 986437/scm 986571";
    }

    private void initFromORBRouterInfo(ORBRouterInfo rInfo) throws Exception {
        String m_method = "initFromORBRouterInfo";
        if (rInfo == null) {
            throw new VWException("orb.serviceHelper.noInitializationInfo", "No initialization information was given for ORB");
        }
        if (this.m_orbRouterInfo != rInfo) {
            this.m_orbRouterInfo = rInfo;
        }
        this.m_host = this.m_orbRouterInfo.serverName;
        this.m_instanceName = this.m_orbRouterInfo.instanceName;
        this.m_port = this.m_orbRouterInfo.serverPort;
        if (logger.isFinest()) {
            logger.finest(m_className, "initFromORBRouterInfo", "ORB Info:" + this.m_orbRouterInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORBServiceHelper(String url) throws Exception {
        String m_method = "ctor:" + url;
        try {
            try {
                logger.entering(m_className, m_method);
                VWCORBANameURL corbaNameUrl = new VWCORBANameURL(url);
                this.m_useNameService = !corbaNameUrl.isIOR();
                this.m_orbRouterInfo = new ORBRouterInfo(url, corbaNameUrl.getHost(), corbaNameUrl.getPort(), corbaNameUrl.getRegion());
            }
            catch (Exception e) {
                VWRMIRouterURL rmiRouterURL = new VWRMIRouterURL(url);
                String router = rmiRouterURL.getFullRouter();
                String routerHost = rmiRouterURL.getHost();
                int routerPort = rmiRouterURL.getPort();
                this.m_orbRouterInfo = VWRegistryTool.ORB_get_router(routerHost, routerPort, router);
            }
            this.initFromORBRouterInfo(this.m_orbRouterInfo);
            java.lang.Object var9_9 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            java.lang.Object var9_10 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    private static synchronized boolean IsWAS6Enabled() {
        String JAVA_HOME;
        String m_method = "IsWAS6Enabled";
        if (ORBServiceHelper.getPrivilegedSystemProperty(WAS6_ENABLED_PROPNAME) != null) {
            logger.finest(m_className, "IsWAS6Enabled", "YES via property");
            return true;
        }
        if (WAS6FILE_NAME == null && (JAVA_HOME = ORBServiceHelper.getPrivilegedSystemProperty("java.home")) != null) {
            try {
                File parentLib = new File(JAVA_HOME, "lib");
                File f = new File(parentLib, WAS6_ENABLED_PROPNAME);
                WAS6FILE_NAME = f.getCanonicalPath();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (WAS6FILE_NAME != null) {
            boolean res = new File(WAS6FILE_NAME).exists();
            if (res) {
                logger.finest(m_className, "IsWAS6Enabled", "YES via File");
            }
            return res;
        }
        return false;
    }

    public ORB getORB() throws Exception {
        if (this.m_orb == null) {
            try {
                if (this.m_useNameService) {
                    this.getORBwithNameService(this.m_host, this.m_port);
                } else {
                    this._getORB();
                }
            }
            catch (Throwable t) {
                throw new VWException(t);
            }
        }
        return this.m_orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _getORB() throws VWException {
        String m_method = "_getORB";
        java.lang.Object object = syncObj;
        synchronized (object) {
            String s = ORBServiceHelper.getPrivilegedSystemProperty("filenet.pe.peorb.pool.guard");
            if (s != null) {
                GUARD_SHARED_ORB = new Boolean(s);
            }
            if (!IsWAS6 && IsIBMORB) {
                IsWAS6 = ORBServiceHelper.IsWAS6Enabled();
            }
            if ((IsIBMORB || IsWAS6) && propLogger.isFinest() && !tracedProps) {
                propLogger.finest(m_className, "_getORB", Logger.traceProperties("BEFORE GETTING SHARED ORB"));
            }
            if (!(STANDALONE || IsWAS6_Init && !IsWAS6)) {
                IsWAS6_Init = true;
                String NAMING_FACTORY_URL_PKGS = "java.naming.factory.url.pkgs";
                String savedOldNamingFactoryUrlPkgs = ORBServiceHelper.getPrivilegedSystemProperty("java.naming.factory.url.pkgs");
                if (logger.isFinest() && !tracedProps) {
                    logger.finest(m_className, "_getORB", "java.naming.factory.url.pkgs=" + savedOldNamingFactoryUrlPkgs);
                }
                try {
                    Hashtable<?, ?> h;
                    InitialContext ctx;
                    block29: {
                        if (savedOldNamingFactoryUrlPkgs != null && savedOldNamingFactoryUrlPkgs.indexOf("com.ibm.ws.runtime") != -1) {
                            IsWAS6 = true;
                        }
                        ctx = new InitialContext();
                        h = null;
                        try {
                            h = ctx.getEnvironment();
                        }
                        catch (Throwable e) {
                            if (!IsWAS6) break block29;
                            logger.throwing(m_className, "_getORB", e);
                        }
                    }
                    if (!IsWAS6 && h != null) {
                        String namingFactoryClass = (String)h.get("java.naming.factory.initial");
                        boolean bl = IsWAS6 = namingFactoryClass != null && namingFactoryClass.equals("com.ibm.websphere.naming.WsnInitialContextFactory");
                    }
                    if (IsWAS6) {
                        this.m_orb = (ORB)PortableRemoteObject.narrow((java.lang.Object)ctx.lookup("java:comp/ORB"), ORB.class);
                    }
                    boolean bl = IsWAS6 = this.m_orb != null;
                    if (IsWAS6 && logger.isFinest() && !tracedProps) {
                        logger.finest(m_className, "_getORB", "Using appserver shared ORB.");
                    }
                    if ((IsIBMORB || IsWAS6) && propLogger.isFinest() && !tracedProps) {
                        propLogger.finest(m_className, "_getORB", Logger.traceProperties("AFTER GETTING SHARED ORB"));
                    }
                }
                catch (Exception e) {
                    if (IsIBMORB && logger.isFinest()) {
                        logger.throwing(m_className, "_getORB", e);
                    }
                    IsWAS6 = false;
                }
            }
        }
        if (this.m_orb == null) {
            String minORBs = ORBServiceHelper.getPrivilegedSystemProperty("filenet.pe.peorb.pool.min");
            String maxORBs = ORBServiceHelper.getPrivilegedSystemProperty("filenet.pe.peorb.pool.max");
            if (maxORBs == null) {
                maxORBs = "10";
            }
            if (minORBs == null) {
                minORBs = "1";
            }
            if (minORBs != null) {
                java.lang.Object object2 = syncORBObj;
                synchronized (object2) {
                    if (G_ORBPOOL == null) {
                        G_ORBPOOL = new ORBPOOL(minORBs, maxORBs, ORBServiceHelper.setUTF8CodeSet());
                    }
                    this.m_orb = G_ORBPOOL.getORB();
                }
            } else {
                this.m_orb = ORB.init((String[])new String[0], (Properties)ORBServiceHelper.setUTF8CodeSet());
            }
        }
        if (this.m_orb == null) {
            throw new VWException("orb.serviceHelper.failedToGetORB", "Unable to instantiate an ORB");
        }
        if (logger.isFinest() && !tracedProps) {
            logger.finest(m_className, "_getORB", this.m_orb.getClass().getName());
        }
        tracedProps = true;
        this.checkORBDebugFlags();
    }

    public IPERPC getPERPC() throws Exception {
        if (this.m_useNameService) {
            return this.getPERPC_via_NS();
        }
        return this.getPERPC_via_IOR(this.getPERPCIOR());
    }

    private void checkORBDebugFlags() {
        try {
            if (this.m_orb == null || IsIBMORB || IsWebLogicORB) {
                return;
            }
            Class<?> orbClass = this.m_orb.getClass();
            String orbDebugString = ORBServiceHelper.getPrivilegedSystemProperty("ORBDebug");
            if (orbDebugString == null) {
                return;
            }
            String[] debugFlags = orbDebugString.split(",");
            int nItems = debugFlags == null ? 0 : debugFlags.length;
            for (int i = 0; i < nItems; ++i) {
                String fieldName = debugFlags[i] + "DebugFlag";
                try {
                    Field f = orbClass.getField(fieldName);
                    f.setBoolean(this.m_orb, true);
                    if (!logger.isFinest()) continue;
                    logger.finest(m_className, "checkORBDebugFlags", fieldName);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static long GetRPC_TIMEOUT(long defaultValue) {
        long res = defaultValue;
        try {
            res = LOCAL_TIMEOUT > 0L ? LOCAL_TIMEOUT : Long.parseLong(ORBServiceHelper.getPrivilegedSystemProperty("filenet.vw.api.rpc.timeout"));
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "GetRPC_TIMEOUT", Long.toString(res) + "ms");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPERPCIOR() throws Exception {
        String m_method = "getPERPCIOR";
        long startTime = System.currentTimeMillis();
        try {
            String key = this.m_host + ":" + this.m_port;
            String curIOR = null;
            TTLObject ttlIOR = IORCache.get(key);
            if (ttlIOR != null) {
                curIOR = (String)ttlIOR.getObject();
            }
            if (curIOR != null) {
                String string = curIOR;
                java.lang.Object var21_8 = null;
                SyncVersion.updateStats("getPERPCIOR", System.currentTimeMillis() - startTime);
                return string;
            }
            StringBuffer buf = new StringBuffer();
            if (this.m_host.startsWith("http")) {
                if (this.m_host.endsWith("/")) {
                    this.m_host = this.m_host.substring(0, this.m_host.length() - 1);
                }
                buf.append(this.m_host);
            } else {
                buf.append("http://").append(this.m_host).append(":").append(this.m_port);
            }
            buf.append("/IOR/FileNet.PE.vworbbroker");
            if (this.m_instanceName != null) {
                buf.append("?name=").append(this.m_instanceName);
            }
            String url = buf.toString();
            HttpURLConnection conn = null;
            BufferedReader data = null;
            long rpcTimeout = ORBServiceHelper.GetRPC_TIMEOUT(180000L);
            RetryManager retry = new RetryManager(rpcTimeout);
            String ior = null;
            do {
                java.lang.Object var19_22;
                block24: {
                    String e222222;
                    block25: {
                        URL theURL = new URL(url);
                        conn = (HttpURLConnection)theURL.openConnection();
                        conn.setConnectTimeout((int)rpcTimeout);
                        conn.setRequestMethod("GET");
                        if (logger.isFinest()) {
                            logger.fine(m_className, "getPERPCIOR", "Connecting " + url);
                        }
                        conn.connect();
                        data = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        try {
                            String line;
                            while ((line = data.readLine()) != null) {
                                if (logger.isFinest()) {
                                    logger.finest(m_className, "getPERPCIOR", "Line = " + line);
                                }
                                if (!line.startsWith("IOR") && !line.toLowerCase().startsWith("http")) continue;
                                ior = line;
                            }
                        }
                        catch (Exception e222222) {
                            logger.throwing(m_className, "getPERPCIOR", e222222);
                        }
                        if (ior == null) {
                            if (!retry.again()) {
                                throw new VWORBBrokerNotStarted(FAILED_TO_GETVWBROKER_IOR.toString(url));
                            }
                            retry.sleep(5000);
                            break block24;
                        }
                        IORCache.put(key, new TTLObject(ior, "filenet.pe.ior.cache.ttl.in.seconds", 3600L, 2));
                        e222222 = ior;
                        var19_22 = null;
                        if (data == null) break block25;
                        data.close();
                    }
                    data = null;
                    java.lang.Object var21_9 = null;
                    SyncVersion.updateStats("getPERPCIOR", System.currentTimeMillis() - startTime);
                    return e222222;
                }
                try {
                    var19_22 = null;
                    if (data != null) {
                        data.close();
                    }
                    data = null;
                    continue;
                    catch (IOException ioEx) {
                        VWException vwex = ConfigUtils.getHttpServerError(ioEx, conn);
                        String s = VWException.DescribeThrowableAndItsCause(vwex);
                        logger.throwing(m_className, "getPERPCIOR", ioEx);
                        if (!retry.again()) {
                            throw new NameServerNotStarted(FAILED_TO_CONNECT_TO_VWIOR.toString(url, s));
                        }
                        retry.sleep(5000);
                        var19_22 = null;
                        if (data != null) {
                            data.close();
                        }
                        data = null;
                    }
                }
                catch (Throwable throwable) {
                    var19_22 = null;
                    if (data != null) {
                        data.close();
                    }
                    data = null;
                    throw throwable;
                }
            } while (retry.again());
            throw new VWORBBrokerNotStarted(FAILED_TO_GETVWBROKER_IOR.toString(url));
        }
        catch (Throwable throwable) {
            java.lang.Object var21_10 = null;
            SyncVersion.updateStats("getPERPCIOR", System.currentTimeMillis() - startTime);
            throw throwable;
        }
    }

    private IPERPC getPERPC_via_IOR(String ior) throws VWException {
        if (ior == null) {
            throw new VWException("orb.serviceHelper.nullIOR", "IOR is null.");
        }
        if (ior.startsWith("IOR")) {
            this._getORB();
            if (this.m_orb == null) {
                throw new VWException("orb.serviceHelper.nullORB", "ORB is null.");
            }
            return PERPCProxy.getInstanceViaORB(PERPCHelper.narrow(this.m_orb.string_to_object(ior)));
        }
        if (ior.toLowerCase().startsWith("http")) {
            return PERPCProxy.getInstanceViaHTTP(ior);
        }
        throw new VWException("orb.serviceHelper.invalidIOR", "Invalid {0}.", ior);
    }

    private IPERPC getPERPC_via_NS() throws Exception {
        if (this.m_orbNC == null) {
            throw new VWException("orb.serviceHelper.noNameService", "No available ORB name service was found.");
        }
        NameComponent[] path = new NameComponent[]{new NameComponent("FileNet", "FNPE"), new NameComponent("PE", "FNPE"), new NameComponent("vworbbroker", "FNPE")};
        return PERPCProxy.getInstanceViaORB(PERPCHelper.narrow(this.m_orbNC.resolve(path)));
    }

    protected ORBServiceHelper(ORBRouterInfo rInfo, boolean useNameService) throws Exception {
        this.m_orbRouterInfo = rInfo;
        this.m_useNameService = useNameService;
        this.initFromORBRouterInfo(this.m_orbRouterInfo);
    }

    public ORBServiceHelper(String nsHost, int nsPort, boolean useNameService) throws Exception {
        this.m_orbRouterInfo = new ORBRouterInfo("anonymous", nsHost, nsPort, -1);
        this.m_useNameService = useNameService;
        this.initFromORBRouterInfo(this.m_orbRouterInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties setUTF8CodeSet() {
        if (calledsetUtf8CodeSet) {
            return ORBPROPS;
        }
        Properties properties = ORBPROPS;
        synchronized (properties) {
            String codeSetPropertyName = IsIBMORB ? "com.ibm.CORBA.ORBCharEncoding" : "com.sun.CORBA.codeset.charsets";
            String codeSetPropertyValue = IsIBMORB ? "UTF8" : "0x05010001";
            String m_method = "setUTF8CodeSet";
            ORBPROPS.put(codeSetPropertyName, codeSetPropertyValue);
            if (logger.isFinest()) {
                logger.finest(m_className, "setUTF8CodeSet", codeSetPropertyName);
            }
            calledsetUtf8CodeSet = true;
            Properties p = JVMSystemConstants.get_p8bpmsystems_properties();
            Enumeration<java.lang.Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("filenet.pe.peorb.ORBParams.")) continue;
                String oKey = key.substring("filenet.pe.peorb.ORBParams.".length());
                String oValue = p.getProperty(key);
                if (logger.isFinest()) {
                    logger.finest(m_className, "setUTF8CodeSet", oKey + "=" + oValue);
                }
                ORBPROPS.setProperty(oKey, oValue);
            }
            return ORBPROPS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetORBProperties(Properties p) {
        Properties properties = ORBPROPS;
        synchronized (properties) {
            Enumeration<java.lang.Object> keyEnum = p.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                String value = p.getProperty(key);
                if (logger.isFinest()) {
                    logger.finest(m_className, "SetORBProperties", key + "=" + value);
                }
                ORBPROPS.setProperty(key, value);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ORB getORBwithNameService(String nsHost, int nsPort) throws Exception {
        String m_method = "getORBwithNameService:" + nsHost + ":" + nsPort;
        logger.entering(m_className, m_method);
        try {
            try {
                Properties p = ORBServiceHelper.setUTF8CodeSet();
                p.put("org.omg.CORBA.ORBInitialHost", nsHost);
                p.put("org.omg.CORBA.ORBInitialPort", Integer.toString(nsPort));
                this.m_orb = ORB.init((String[])new String[0], (Properties)p);
                if (this.m_orb == null) {
                    throw new VWException("orb.serviceHelper.failedToGetORBAtHost", "Unable to instantiate an ORB from naming service {0}:{1}", new java.lang.Object[]{nsHost, new Integer(nsPort)});
                }
                this.checkORBDebugFlags();
                Object ns_obj = this.m_orb.resolve_initial_references("NameService");
                this.m_orbNC = NamingContextHelper.narrow((Object)ns_obj);
                ORB oRB = this.m_orb;
                java.lang.Object var8_12 = null;
                logger.exiting(m_className, m_method);
                return oRB;
            }
            catch (COMM_FAILURE commEx) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Got COMM_FAILURE:!" + commEx.getLocalizedMessage());
                }
                String s = VWException.DescribeThrowableAndItsCause(commEx);
                throw new NameServerNotStarted(FAILED_TO_CONNECT_TO_NS.toString(nsHost, new Integer(nsPort), s));
            }
            catch (InvalidName invEx) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Got COMM_FAILURE:!" + invEx.getLocalizedMessage());
                }
                String s = VWException.DescribeThrowableAndItsCause(invEx);
                throw new NameServerNotStarted(FAILED_TO_CONNECT_TO_NS.toString(nsHost, new Integer(nsPort), s));
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var8_13 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    public void destroyORB() {
        String m_method = "destroyORB";
        if (this.m_orb != null) {
            Iterator<java.lang.Object> iter = this.m_BoundObjects.iterator();
            while (iter.hasNext()) {
                try {
                    if (this.m_useNameService) {
                        NameComponent[] names = (NameComponent[])iter.next();
                        this.unbindFromNameServer(names);
                        continue;
                    }
                    this.unbindFromIORServer((String)iter.next());
                }
                catch (Throwable e) {}
            }
            this.m_BoundObjects.clear();
            try {
                if (!IsIBMORB && G_ORBPOOL == null && this.m_orb != null) {
                    this.m_orb.shutdown(false);
                    this.m_orb.destroy();
                }
            }
            catch (Throwable t) {
                logger.throwing(m_className, "destroyORB", t);
            }
        }
        this.m_orbNC = null;
        this.m_orb = null;
    }

    protected void finalize() {
        this.destroyORB();
    }

    private static String NameComponentsToString(NameComponent[] path) {
        int nPaths;
        int n = nPaths = path == null ? 0 : path.length;
        if (nPaths == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < nPaths; ++i) {
            buf.append(path[i].id);
            if (i >= nPaths - 1) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void bindToIORServer(String name, Object obj) throws Exception {
        if (this.m_orb == null) {
            return;
        }
        String m_method = "bindToIORServer:" + name;
        StringBuffer buf = new StringBuffer();
        buf.append("http://").append(this.m_host).append(":").append(this.m_port).append("/IOR/").append(name).append("?").append(name).append("=").append(this.m_orb.object_to_string(obj));
        String url = buf.toString();
        HttpURLConnection conn = null;
        BufferedReader data = null;
        RetryManager retry = new RetryManager(ORBServiceHelper.GetRPC_TIMEOUT(180000L));
        do {
            java.lang.Object var14_13;
            try {
                try {
                    URL theURL = new URL(url);
                    conn = (HttpURLConnection)theURL.openConnection();
                    conn.setRequestMethod("GET");
                    if (logger.isFinest()) {
                        logger.fine(m_className, m_method, "We're connecting " + url);
                    }
                    conn.connect();
                    InputStream in = conn.getInputStream();
                    InputStreamReader inReader = new InputStreamReader(in);
                    data = new BufferedReader(inReader);
                    String line = data.readLine();
                    while ((line = data.readLine()) != null) {
                        if (!logger.isFinest()) continue;
                        logger.finest(m_className, m_method, "Line = " + line);
                    }
                    this.m_BoundObjects.add(name);
                    retry.stop();
                    var14_13 = null;
                    if (data == null) return;
                }
                catch (IOException ioEx) {
                    logger.throwing(m_className, m_method, ioEx);
                    VWException vwex = ConfigUtils.getHttpServerError(ioEx, conn);
                    String s = VWException.DescribeThrowableAndItsCause(vwex);
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, s);
                    }
                    if (!retry.again()) {
                        throw new NameServerNotStarted(FAILED_TO_CONNECT_TO_VWIOR.toString(url, s));
                    }
                    retry.sleep(5000);
                    var14_13 = null;
                    if (data != null) {
                        data.close();
                    }
                    data = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_13 = null;
                if (data != null) {
                    data.close();
                }
                data = null;
                throw throwable;
            }
            data.close();
            return;
        } while (retry.again());
    }

    public void bindToNameServer(NameComponent[] path, Object obj, boolean rebind, String name) throws Exception {
        block5: {
            int nPaths;
            String m_method = "bind:" + name;
            NamingContext thisNC = this.m_orbNC;
            int n = nPaths = path == null ? 0 : path.length;
            if (nPaths == 0) {
                return;
            }
            for (int i = 0; i < nPaths - 1; ++i) {
                thisNC = ORBServiceHelper.getContext(thisNC, path[i], true);
            }
            NameComponent[] objClosestPath = new NameComponent[]{path[nPaths - 1]};
            try {
                thisNC.bind(objClosestPath, obj);
                this.m_BoundObjects.add(path);
            }
            catch (AlreadyBound e1) {
                if (!rebind) break block5;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "rebind obj");
                }
                thisNC.rebind(objClosestPath, obj);
            }
        }
    }

    public void bind(NameComponent[] path, Object obj, boolean rebind) throws Exception {
        int nPaths;
        int n = nPaths = path == null ? 0 : path.length;
        if (nPaths == 0) {
            return;
        }
        String name = ORBServiceHelper.NameComponentsToString(path);
        if (this.m_useNameService) {
            this.bindToNameServer(path, obj, rebind, name);
        } else {
            this.bindToIORServer(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unbindFromIORServer(String name) throws Exception {
        String m_method = "unbindFromIORServer:" + name;
        StringBuffer buf = new StringBuffer();
        buf.append("http://").append(this.m_host).append(":").append(this.m_port).append("/IOR/").append(name).append("?").append(name).append("=REMOVE");
        String url = buf.toString();
        HttpURLConnection conn = null;
        BufferedReader data = null;
        try {
            String line;
            URL theURL = new URL(url);
            conn = (HttpURLConnection)theURL.openConnection();
            conn.setRequestMethod("GET");
            if (logger.isFinest()) {
                logger.fine(m_className, m_method, "We're connecting " + url);
            }
            conn.connect();
            data = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = data.readLine()) != null) {
                if (!logger.isFinest()) continue;
                logger.finest(m_className, m_method, "Line = " + line);
            }
            this.m_BoundObjects.add(name);
            java.lang.Object var10_9 = null;
            if (data == null) return;
        }
        catch (Throwable throwable) {
            java.lang.Object var10_10 = null;
            if (data == null) throw throwable;
            data.close();
            throw throwable;
        }
        data.close();
    }

    public void unbindFromNameServer(NameComponent[] path) throws Exception {
        int nPaths;
        String m_method = "unbind:" + ORBServiceHelper.NameComponentsToString(path);
        int n = nPaths = path == null ? 0 : path.length;
        if (nPaths == 0) {
            return;
        }
        NamingContext thisNC = this.m_orbNC;
        for (int i = 0; i < nPaths - 1; ++i) {
            thisNC = ORBServiceHelper.getContext(thisNC, path[i], false);
        }
        NameComponent[] objClosestPath = new NameComponent[]{path[nPaths - 1]};
        try {
            thisNC.unbind(objClosestPath);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
    }

    private static NamingContext getContext(NamingContext parent, NameComponent n, boolean createIt) throws Exception {
        NamingContext nc;
        block3: {
            if (parent == null) {
                return null;
            }
            nc = null;
            Object cobj = null;
            NameComponent[] path = new NameComponent[]{n};
            try {
                cobj = parent.resolve(path);
                nc = NamingContextHelper.narrow((Object)cobj);
            }
            catch (NotFound e1) {
                if (!createIt) break block3;
                nc = parent.bind_new_context(path);
            }
        }
        return nc;
    }

    private static boolean isContext(Binding b) {
        return b.binding_type == BindingType.ncontext;
    }

    public void listBindings(PrintStream out) throws Exception {
        out.println("Listing Naming Service bindings at " + this.m_orbRouterInfo + "...");
        ORBServiceHelper._listBindings(this.m_orb, this.m_orbNC, out, "Root");
    }

    private static void _listBindings(ORB theOrb, NamingContext nc, PrintStream out, String parentName) throws Exception {
        BindingListHolder blist = new BindingListHolder();
        BindingIteratorHolder biteratorHolder = new BindingIteratorHolder();
        nc.list(10, blist, biteratorHolder);
        Binding[] bindings = blist.value;
        int nBindings = bindings == null ? 0 : bindings.length;
        for (int i = 0; i < nBindings; ++i) {
            ORBServiceHelper._listABinding(theOrb, nc, out, parentName, bindings[i]);
        }
        BindingIterator biterator = BindingIteratorHelper.narrow((Object)biteratorHolder.value);
        boolean more = biterator != null;
        BindingHolder bholder = new BindingHolder();
        while (more) {
            more = biterator.next_one(bholder);
            ORBServiceHelper._listABinding(theOrb, nc, out, parentName, bholder.value);
        }
    }

    private static void _listABinding(ORB theOrb, NamingContext nc, PrintStream out, String parentName, Binding b) throws Exception {
        if (b.binding_name == null || b.binding_name.length == 0) {
            return;
        }
        String myPath = parentName + "." + ORBServiceHelper.NameComponentsToString(b.binding_name);
        if (ORBServiceHelper.isContext(b)) {
            out.print("[Binding Context]");
        } else {
            out.print("[Binding Object] ");
        }
        out.print(myPath);
        Object obj = nc.resolve(b.binding_name);
        String objStr = theOrb.object_to_string(obj);
        out.print(" ");
        out.println(objStr);
        if (ORBServiceHelper.isContext(b)) {
            ORBServiceHelper._listBindings(theOrb, ORBServiceHelper.getContext(nc, b.binding_name[0], false), out, myPath);
        }
    }

    private static void printUsage() {
        System.out.println("ORBServiceHelper [/rpc={ping, kill, listNS}] [/useNameSerivce] [/startNS] /host=nameServiceHost /port=nameServicePort");
        System.out.println("   or /inputfile <inputfile> where inputfile contains the parameters, e.g.");
        System.out.println("  rpc={ping, kill, listNS}");
        System.out.println("  router=host:port/routername, default is localhost:32771/vwrouter.ORB");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            IPERPC service;
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h") || c.isPresent("H") || c.isPresent("?")) {
                ORBServiceHelper.printUsage();
            }
            String routerURL = c.getParameter("router");
            String host = c.getParameter("host", "localhost");
            int port = c.getIntParameter("port", 32776);
            boolean useNameService = c.isPresent("useNameService");
            String rpc = c.getParameter("rpc", "ping");
            boolean startNS = c.isPresent("startNS");
            ORBServiceHelper m_orbSvc = null;
            boolean tryAgain = false;
            do {
                tryAgain = false;
                try {
                    if (routerURL != null) {
                        m_orbSvc = new ORBServiceHelper(routerURL);
                        continue;
                    }
                    m_orbSvc = new ORBServiceHelper(host, port, useNameService);
                }
                catch (NameServerNotStarted nse) {
                    if (startNS) {
                        System.out.println("About to start NS");
                        String cmd = "c:\\j2sdk1.4.2_07\\bin\\orbd -ORBInitialPort " + port;
                        Runtime.getRuntime().exec(cmd);
                        tryAgain = true;
                        Thread.sleep(5000L);
                        continue;
                    }
                    throw nse;
                }
            } while (tryAgain);
            if (rpc.equals("ping")) {
                service = m_orbSvc.getPERPC();
                String response = (String)service.invokeRPC("orb_rpc_ping", new java.lang.Object[]{"From TEST Client"});
                System.out.println("Pinged " + host + ":" + port + ".  Server response = " + response);
                System.exit(0);
            }
            if (rpc.equals("stats")) {
                service = m_orbSvc.getPERPC();
                PECallStats[] stats = (PECallStats[])service.invokeRPC("orb_rpc_getCallStatistics", new java.lang.Object[0]);
                for (int i = 0; i < stats.length; ++i) {
                    System.out.println("[" + i + "] nCalls=" + stats[i].nCalls + ", procTimePerCallInMs=" + stats[i].procTimePerCallInMs + ", totalTimeInSec=" + stats[i].totalTimeInSec);
                }
            }
            if (rpc.equals("kill")) {
                service = m_orbSvc.getPERPC();
                service.invokeRPC("orb_rpc_shutdown", new java.lang.Object[0]);
                System.out.println("Killed " + host + ":" + port);
                System.exit(0);
            }
            if (rpc.equals("listNS") && useNameService) {
                m_orbSvc.listBindings(System.out);
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        syncObj = new java.lang.Object();
        syncORBObj = new java.lang.Object();
        GUARD_SHARED_ORB = false;
        STANDALONE = false;
        LOCAL_TIMEOUT = -1L;
        try {
            STANDALONE = ORBServiceHelper.getPrivilegedSystemProperty("filenet.pe.standalone") != null;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Class.forName("com.ibm.CORBA.iiop.ORB");
            IsIBMORB = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!IsIBMORB) {
            try {
                Class.forName("weblogic.corba.orb.ORB");
                IsWebLogicORB = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        logger = Logger.getLogger("filenet.pe.peorb.orb");
        propLogger = Logger.getLogger("filenet.pe.peorb.system");
        WAS6FILE_NAME = null;
        FAILED_TO_GETVWBROKER_IOR = new VWString("orbservicehelper.failed.novworbbroker.ior", "Failed to retrieve an IOR for vworbbroker. URL={0}.  Check PE server to make sure that vworbbroker process is started.");
        FAILED_TO_CONNECT_TO_VWIOR = new VWString("orbservicehelper.failed.toconnect.tovwior", "Failed to connect to vwior. URL={0}. Check PE server to make sure that vwior process is started. {1}");
        FAILED_TO_CONNECT_TO_NS = new VWString("orbservicehelper.failed.toconnect.toNameService", "Failed to connect to name service at {0}:{1}. {2}");
        IORCache = new WeakHashMap(5);
        ORBPROPS = new Properties();
        AccessController.doPrivileged(new PrivilegedAction<java.lang.Object>(){

            @Override
            public java.lang.Object run() {
                Properties p = System.getProperties();
                Enumeration<java.lang.Object> sysPropKeyEnum = p.keys();
                while (sysPropKeyEnum.hasMoreElements()) {
                    String key = (String)sysPropKeyEnum.nextElement();
                    String prefix = "filenet.pe.peorb.properties.";
                    if (!key.startsWith("filenet.pe.peorb.properties.")) continue;
                    String propName = key.substring("filenet.pe.peorb.properties.".length());
                    String value = p.getProperty(key);
                    if (logger.isFinest()) {
                        logger.finest(ORBServiceHelper.m_className, "static", propName + "=" + value);
                    }
                    ORBPROPS.setProperty(key, value);
                }
                return null;
            }
        });
        calledsetUtf8CodeSet = false;
    }

    public class PEDirectoryServerNotStarted
    extends ConnectException {
        private static final long serialVersionUID = 464L;

        public PEDirectoryServerNotStarted(String s) {
            super(s);
        }
    }

    public class VWORBBrokerNotStarted
    extends ConnectException {
        private static final long serialVersionUID = 464L;

        public VWORBBrokerNotStarted(String s) {
            super(s);
        }
    }

    public class NameServerNotStarted
    extends ConnectException {
        private static final long serialVersionUID = 464L;

        public NameServerNotStarted(String s) {
            super(s);
        }
    }

    class ORBPOOL {
        private Vector<ORB> pool;
        private int m_curORBIndex;
        private int m_poolCapacity;
        private Properties m_orbProps;

        public ORBPOOL(String minORBs, String maxORBs, Properties orbProps) throws IllegalArgumentException {
            int minPoolSize;
            this.m_orbProps = orbProps;
            if (minORBs == null) {
                throw new IllegalArgumentException("Invalid number of arguments..");
            }
            try {
                minPoolSize = Integer.parseInt(minORBs);
            }
            catch (Exception e) {
                minPoolSize = 1;
            }
            try {
                this.m_poolCapacity = Integer.parseInt(maxORBs);
            }
            catch (Throwable e) {
                this.m_poolCapacity = minPoolSize + 5;
            }
            this.pool = new Vector(this.m_poolCapacity);
            if (orbProps != null && propLogger.isFinest()) {
                propLogger.finest("ORBPOOL", "init", orbProps.toString());
            }
            for (int i = 0; i < minPoolSize; ++i) {
                this.pool.add(ORB.init((String[])new String[0], (Properties)this.m_orbProps));
            }
        }

        protected ORB getORB() {
            int curPoolSize = this.pool.size();
            if (++this.m_curORBIndex > this.m_poolCapacity) {
                this.m_curORBIndex = 1;
            }
            if (this.m_curORBIndex > curPoolSize && curPoolSize < this.m_poolCapacity) {
                if (logger.isFinest()) {
                    logger.finest("ORBPOOL", "getORB", "newORB needed, " + curPoolSize);
                }
                this.pool.add(ORB.init((String[])new String[0], (Properties)this.m_orbProps));
            }
            if (logger.isFinest()) {
                logger.finest("ORBPOOL", "getORB", "return: " + this.m_curORBIndex);
            }
            return this.pool.get(this.m_curORBIndex - 1);
        }

        public void cleanup() {
            Enumeration<ORB> poolEnum = this.pool.elements();
            while (poolEnum.hasMoreElements()) {
                ORB anOrb = poolEnum.nextElement();
                anOrb.shutdown(false);
                anOrb.destroy();
            }
            this.pool.clear();
        }
    }
}

